# Installation

Unpack everything to the root folder of the game, overwriting already existing GameData and Ships folders.

Source folder contains the source code for the included plugins and is not necessary for the mod to work.

Make sure you have KSP 1.5.0 or higher.

Do *not*, under any circumstances, extract just `GameData/B9_Aerospace/Parts` folder alone, the mod won't work this way.

With a proper installation, you should have multiple new folders in GameData alongside with Squad folder that was there originally.

Do not try to move the part folders anywhere or sort them by category subfolders, that will break resource linking in all configs.

___________________________________

# About

This set of parts vastly expands a selection of parts, in particular with spaceplane components such as new engines, cockpits, wings and fuselage systems.

The style was influenced by futuristic concept art, modern UAV designs, some believable hard sci-fi ideas, DARPA & NASA aerospace research, and by asymmetrical shapes and faceted designs that are nowadays common everywhere from automotive industry to military aircraft.

I have decided not to go overboard with realistic art style or extreme colors: my intention is to make parts which would blend seamlessly with, for example, KW Rocketry pieces.

My textures are hand-painted, I’m avoiding photo-sourced areas or excessive detail like rust.

Everything looks just a little bit cartoony, like a concept art, which, in my opinion, fits nicely with the general art style of KSP (most of the stock part textures were painted too).

Although I’m going for higher fidelity and texture resolution, so don’t expect a 100% match – but I’m fairly satisfied with results and have already built some neat ships using them.

The goal of the project is to fill every empty niche in KSP part selection and to replace every sub-par component with a new part better suited for the role.

Full changelog, support and development updates can be found in the [forum thread](http://forum.kerbalspaceprogram.com/index.php?showtopic=155491).



___________________________________

# Credits

## Core Team

* bac9 - 3D modeling, texturing, project lead
* Taverius - balance, 3D modeling, craft design, maintenance
* K3|Chris - 3D modeling, texturing, IVA


## Contributors and bundled mods

* Nazari - HotRockets Engine FX: [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=59710)
* Snjo, Roverdude - Firespitter.dll plugin: [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=22583)
* Sarbian - SmokeScreen.dll plugin: [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=64987)
* Ialdabaoth, Sarbian: ModuleManager: [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=50533)
* Mihara - RasterPropMonitor: [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=105821)
* blowfish - B9AnimationModules.dll: [github](https://github.com/blowfishpro/B9AnimationModules)
* blowfish - B9PartSwitch.dll: [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=140541)
* jadebenn, Hyomoto, Helldiver - RPM MFD configuration.
* alexustas - RPM MFD model, configuration.
* FPSlacker - HotRockets exhaust flame atmospheric compensation.


## Contributors to previously bundled mods

* Fel - ResGen.dll plugin: [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=26710)
* NathanKell - CrossFeedEnabler: [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=69286)
* Kine - KineTechAnimation.dll plugin: [github](http://github.com/KineMorto/KineTechAnimationLibrary)
* Greys - VirginGeneric.dll v1.6.1: [github](http://github.com/Greys0/Virgin-Kalactic)
* dtobi, Sarbian - KM_Gimbal.dll plugin v3.0.5: [github](http://github.com/sarbian/km_Gimbal)


## Special thanks
For answering tons of silly questions.

* DYJ
* C7
* r4m0n
* Sarbian
* NathanKell
* egg
* snjo
* ferram4
* Mu

## 1.0+ Compatiblility and ongoing mainteance

* blowfish - Project coordinator
* flashblade - Many contributions
* V8jester - Stack node adjustments
* M4ck - Stack node adjustments
* danfarnsy - RPM fixes, DRE fixes
* JaredTheDragon - RPM fixes
* joshwoo70 - RT compatibility
* sparkybear - Part tags
* taniwha - Fix for light layers
* Everyone else who I may have forgotten




___________________________________

# License

This work is shared under CC BY-NC-SA 3.0 license. [link](https://creativecommons.org/licenses/by-nc-sa/3.0/)

Components and included code & content may come under their own license. Please check their documentation or their sites.



___________________________________

# Aerodynamics

While we take pains to ensure the parts are balanced in the stock drag model, most of the testing has been done using FAR.  Parts may not behave ideally under the stock drag system.

For the best possible experience with spaceplanes in Kerbal Space Program, you should install FAR:



## Ferram Aerospace Research (FAR)

The true accurate and realistic aerodynamics for KSP.

Can be somewhat daunting for beginners. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=19321)


___________________________________

# Recommendations

These mods are recommended to get the best possible experience with B9 Aerospace:



## Adjustable Landing Gear

Adds landing gear with adjustable size, angles, and height ... [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=89874)



## B9 Aerospace - Procedural Parts

Adds good looking, adjustable-sized wings ... [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=94621)



## Kerbal Joint Reinforcement

Strenghthens your craft so that they don't flop around without dozens of struts ... [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=50911)


___________________________________

# Suggestions

These are some of the mods we like to use when we play KSP, in alphabetical order:



## Aligned Currency [OUTDATED]

Should have been in stock. Simple mod that makes the amount of kerbucks you have line up properly ... [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=79418)



## Alternate Resource Panel

One that's actually useful and informative. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=54876)



## Chatterer

Cute little plugin that plays garbled sounds and radio beeps like you're in a *real* space program. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=83290)



## Coherent Contracts

Squad are from Mexico so we won't hold it against them, but the contracts text sometimes doesn't make grammatical sense. This fixes that problem. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=90272)



## Contracts Window +

Simply put, a (much) better contracts window. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=82106)



## Custom Biomes [OUTDATED]

More places to do science at! [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=60163)



## DebRefund [OUTDATED]

Get money back for those boosters that you manage to parachute safely back to kerbin. Another one of those 'should have been in stock' features. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=78238)



## DMagic Orbital Science

More instruments to do science *with*. Also new science-gathering contracts. Compatible with (and recommends) Custom Biomes. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=59009)



## Docking Port Alignment Indicator

A proper interface for accurately docking. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=40423)



## Editor Extensions

Much needed extra functionality for the VAB/SPH.

After you've used it you won't be able to do without. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=35703)



## Editor Part Highlighter [OUTDATED]

Make the editor highlight of parts from the staging list more obvious. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=46117)



## Enhanced Navball

Extra markers on the navball for Radial, Normal and anti-maneuver. Ghosting for Pro/Retrograde and Maneuver nodes.

Navball functionality that Squad wants to include but hasn't got round to doing yet. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=46454)



## Extraplanetary Launchpads

Mine for metal on planets and moons and build rockets with them.

Use together with Kethane or (with patch) Karbonite to create your Kerbal Space Empire. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=54284)



## EVA Parachutes

Chutes for your kerbals so they can bail from damaged spaceplanes and such. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=23304)



## Firespitter

WW2-era aircraft and helicopter parts, seaplane floats.

The FS plugin enables lots of advanced functionality in B9 (and other mods) and he's done a lot of work just because we asked, so go check it out, and give snjo some encouragement. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=22583)



## Gimbal Auto Trim [OUTDATED]

Extends the default Gimbal Module.

When activated, engines will orient so that the Direction of Thrust is aligned with the Centre of Mass.[forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=70392)


## HotRockets! [OUTDATED]

We use its particle FX to make our engines look nice.

Get the main mod to make other engines look awesome too.

Supports lots of major mods as well as the Squad engines. Both HR and B9 use Sarbian's SmokeScreen, use whichever version of the plugin is the most recent.

HotRockets effects are included in B9, so make sure to remove any B9-specific HotRockets configs.
[forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=59710)



## Improved Chase Camera

An improved chase camera for planes.

Can be toggled at any time to return to the default functionality. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=72457)



## Infernal Robotics

The continuation of the venerable Damned Robotics.

Servo motors, hydraulic rams and other mechanical wizardry for building folding planes, bipedal robots, cargo gantries, and anything else you can think of that needs to rotate or fold or extend or contract. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=104535)



## Karbonite

A resource system alternative to Kethane, using the Open Resource System from KSP Interstellar. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=80650)



## Kethane [OUTDATED]

The Grand-daddy of mineable resource systems. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=22166)



## Kerbal Aircraft Expansion

Modern propeller/turboprop/helicopter engines and landing gear, powered by FireSpitter. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=69426)



## Kerbal Alarm Clock

Create in-game reminders so you don't miss important events, like SOI changes, periapsis/apoapsis, custom orbit points, and much more.

A fundamental mod. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=22809)



## Kerbal Attachment System

Winches, magnets, tubes, EVA functionality.

Do a Curiosity-like flying crane rover landing, airlift splashed-down capsules with your helicopter, connect refueling pipes in EVA.

Use it with Kethane/Karbonite and EPL to connect your remote, self-built KSC together. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=83468)



## Kerbal Engineer Redux

If you're not a fan of mechjeb-style automation, but you still want all that information that stock KSP should give you but does not, this is what you want - more information than you can shake a rocket at. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=17833)



## KSP Interstellar

Advanced propulsion systems, generators and resource gathering.

Nuclear reactors, plasma thrusters, all the way up to antimatter harvesting and warp drives.

Uses the same Open Resource System as Karbonite. [github](http://github.com/WaveFunctionP/KSPInterstellar)



## KSP Stock Tweaks [OUTDATED]

4 plugins to set some defaults:

* Set free cam as default
* Set precision control as default
* Map shows navball by default
* Precision mode applies to joysticks

All can be used independently of each other. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=73151)



## KW Rocketry

Our favourite rocket parts expansion mod - rocket parts done *right*. 'nuff said. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=46894)

Community fixes with 1.0.5 compatibility [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=116989)



## Lack Luster Labs Pack

Large spacecraft/station parts, with habitations modules.

Goes well with the HX parts, so much we made an adapter from one to the other. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=92203)



## MechJeb2

Some purists like to fly everything manually like real astronauts never did.

If you're not one of these people, or like us you've flown so many moon landings manually its just plain gotten old, this is the grand-daddy of autopilots, with more features than we could possibly list here. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=111978)

FAR/NEAR/KM_Gimbal compatibility extensions: [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=55482)



## NavHud

A navball-inspired Head Up Display for when you're not IVA (or maybe you just don't like flying IVA). [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=73692)



## NavUtilities

Better instruments for flight. RPM-compatible. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=77062)



## Part Angle display

See and set the rotations of parts in the editor, and change the fine angle changes from the stock value down all the way down to 0.01 degrees at a time if you need to.

Widely used to create the stock B9 crafts, because 5 degrees is a bit too coarse for planes. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=73551)



## Precise Node

For when the adjustments you're trying to do to a maneuver node are just too small for the default interface. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=44129)



## Procedural Fairings

Payload fairings that automatically resize.

You can reshape and tweak them in the VAB, and use it to make custom inter-stage fairings as well. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=36371)



## Protractor Continued

A classic mod that does one thing and does it right - calculates the optimum departure angles for your interplanetary transfers. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=75115)



## RCS Build Aid

Not just for RCS! Extra markers in the VAB/SPH.

Centre of Mass for empty fuel as well as full. See torque effects of off-centre engine and RCS thrust when designing crafts.

A great help for avoiding nasty surprises with changing center of mass and off-balance RCS. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=33124)



## RealChute Parachute Systems

Improved parachute mechanics.

Gradual deployment, more deployment conditions, editable in vab, and more. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=52931)



## SCANsat

Satellite scanner parts to create detailed in-game maps of planets and moons.

Altitude, slope, biome and anomaly maps with zoom to help you plan your landings or look for that missing monolith. Supports or is supported by Kethane, Karbonite, KSPi, RPM so you can map all your resources with one system and see it in the cockpit. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=72679)



## Science Alert

Lets you know when you've crossed biome borders so you know to run all those experiments. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=69538)



## Space Shuttle Engines

Engines for your SLS/Buran-alikes.

We use the Gimbal plugin from this mod, and its *awesome*. It really does let you build stuff with off-center thrust like the Shuttle Launch System.

Also has some very nice replica main tanks, and utility parts that can trigger staging/action groups based on conditions, there's timers, fuel crossfeed controllers and more. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=51197)



## TAC Fuel Balancer

Automatically balance fuel between tanks, dump fuel, transfer a resource from/to all other tanks, or lock it so resources can't move in or out of it. Highly configurable.

Recommended for any SSTO or plane pilot, it will make keeping your planes balanced as engines draw fuel much easier. [forum](http://forum.kerbalspaceprogram.com/index.php?showtopic=23808)



## TAC Life Support

Resource needs for your kerbals, for those that want a more realistic space program.

Compatible with USI Kolonization System [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=37449)



## Toolbar

The original plugin toolbar, and still superior to the one added to stock in 0.24.

While most plugins that can use it include it, its nice to know where to check for the latest version. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=55420)



## USI Kolonization System

Parts and plugins targeted specifically at setting up remote bases for your kerbals to live and work in. Uses the Open Resource System like KSPi and Karbonite. Compatible (and recommends) TAC Life Support. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=72032)



## Vessel Viewer

Awesome plugin that lets you examine and interact with your craft's parts while IVA. Compatible with RPM. [forums](http://forum.kerbalspaceprogram.com/index.php?showtopic=72855)
